/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.installer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.wurstclient.installer.Config;

public class ClientInstaller {
    private final Config config;
    private JFrame frmWurstClientInstaller;
    private JTextField txtPath;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (args.length != 0) {
            if (args.length != 3 || !"update".equals(args[0])) {
                System.out.println("Syntax: update <minecraft_folder> <output_file>");
                return;
            }
            try {
                Config config;
                Throwable throwable = null;
                Object var3_6 = null;
                try (InputStream in = ClientInstaller.class.getClassLoader().getResourceAsStream("assets/config.json");){
                    InputStreamReader reader = new InputStreamReader(in);
                    config = (Config)new Gson().fromJson((Reader)reader, Config.class);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                new ClientInstaller(config).update(Paths.get(args[1], new String[0]), Paths.get(args[2], new String[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Config config;
                    Throwable throwable = null;
                    Object var3_3 = null;
                    try (InputStream in = ClientInstaller.class.getClassLoader().getResourceAsStream("assets/config.json");){
                        InputStreamReader reader = new InputStreamReader(in);
                        config = (Config)new Gson().fromJson((Reader)reader, Config.class);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    ClientInstaller window = new ClientInstaller(config);
                    window.frmWurstClientInstaller.setVisible(true);
                    window.frmWurstClientInstaller.getContentPane().requestFocusInWindow();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ClientInstaller(Config config) {
        this.config = config;
        this.initialize();
    }

    private void initialize() {
        this.frmWurstClientInstaller = new JFrame();
        this.frmWurstClientInstaller.setTitle(String.valueOf(this.config.getClientName()) + " Client Installer");
        this.frmWurstClientInstaller.setResizable(false);
        this.frmWurstClientInstaller.setBounds(100, 100, 450, 300);
        this.frmWurstClientInstaller.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(16, 16, 16, 16));
        this.frmWurstClientInstaller.getContentPane().add((Component)panel, "Center");
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[2];
        gbl_panel.rowHeights = new int[7];
        gbl_panel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblTitle = new JLabel(String.valueOf(this.config.getClientName()) + " v" + this.config.getClientVersion());
        lblTitle.setFont(new Font("Segoe UI Light", 0, 32));
        GridBagConstraints gbc_lblTitle = new GridBagConstraints();
        gbc_lblTitle.gridx = 0;
        gbc_lblTitle.gridy = 0;
        panel.add((Component)lblTitle, gbc_lblTitle);
        JLabel lblSubtitle = new JLabel("for Minecraft " + this.config.getMcCompatibility());
        lblSubtitle.setFont(new Font("Segoe UI Light", 0, 16));
        GridBagConstraints gbc_lblSubtitle = new GridBagConstraints();
        gbc_lblSubtitle.insets = new Insets(0, 0, 20, 0);
        gbc_lblSubtitle.gridx = 0;
        gbc_lblSubtitle.gridy = 1;
        panel.add((Component)lblSubtitle, gbc_lblSubtitle);
        JLabel lblDescription = new JLabel("<html><center>This installer will install " + this.config.getClientName() + " in the official Minecraft launcher and create a \"" + this.config.getJarName() + "\" profile for it if that doesn't already exist.");
        lblDescription.setFont(new Font("Segoe UI", 0, 12));
        GridBagConstraints gbc_lblDescription = new GridBagConstraints();
        gbc_lblDescription.fill = 2;
        gbc_lblDescription.anchor = 11;
        gbc_lblDescription.insets = new Insets(0, 0, 20, 0);
        gbc_lblDescription.gridx = 0;
        gbc_lblDescription.gridy = 2;
        panel.add((Component)lblDescription, gbc_lblDescription);
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(0, 0, 20, 0);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 3;
        panel.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[4];
        gbl_panel_1.rowHeights = new int[2];
        gbl_panel_1.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JLabel lblminecraftFolder = new JLabel(".minecraft folder");
        GridBagConstraints gbc_lblminecraftFolder = new GridBagConstraints();
        gbc_lblminecraftFolder.insets = new Insets(0, 0, 0, 5);
        gbc_lblminecraftFolder.anchor = 13;
        gbc_lblminecraftFolder.gridx = 0;
        gbc_lblminecraftFolder.gridy = 0;
        panel_1.add((Component)lblminecraftFolder, gbc_lblminecraftFolder);
        this.txtPath = new JTextField();
        this.txtPath.setText(this.findDotMinecraftFolder().toString());
        GridBagConstraints gbc_txtPath = new GridBagConstraints();
        gbc_txtPath.insets = new Insets(0, 0, 0, 5);
        gbc_txtPath.fill = 2;
        gbc_txtPath.gridx = 1;
        gbc_txtPath.gridy = 0;
        panel_1.add((Component)this.txtPath, gbc_txtPath);
        this.txtPath.setColumns(10);
        JButton btnBrowse = new JButton("browse");
        btnBrowse.addActionListener(e -> this.browse());
        GridBagConstraints gbc_btnBrowse = new GridBagConstraints();
        gbc_btnBrowse.gridx = 2;
        gbc_btnBrowse.gridy = 0;
        panel_1.add((Component)btnBrowse, gbc_btnBrowse);
        JPanel panel_2 = new JPanel();
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.insets = new Insets(0, 0, 5, 0);
        gbc_panel_2.anchor = 15;
        gbc_panel_2.fill = 2;
        gbc_panel_2.gridx = 0;
        gbc_panel_2.gridy = 4;
        panel.add((Component)panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[5];
        gbl_panel_2.rowHeights = new int[2];
        gbl_panel_2.columnWeights = new double[]{1.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_2.setLayout(gbl_panel_2);
        JButton btnInstall = new JButton("Install");
        btnInstall.addActionListener(e -> this.install());
        btnInstall.setMargin(new Insets(4, 32, 4, 32));
        GridBagConstraints gbc_btnInstall = new GridBagConstraints();
        gbc_btnInstall.insets = new Insets(0, 0, 0, 20);
        gbc_btnInstall.gridx = 1;
        gbc_btnInstall.gridy = 0;
        panel_2.add((Component)btnInstall, gbc_btnInstall);
        JButton btnExtract = new JButton("Extract");
        btnExtract.addActionListener(e -> this.extract());
        btnExtract.setMargin(new Insets(4, 32, 4, 32));
        GridBagConstraints gbc_btnExtract = new GridBagConstraints();
        gbc_btnExtract.insets = new Insets(0, 0, 0, 5);
        gbc_btnExtract.gridx = 2;
        gbc_btnExtract.gridy = 0;
        panel_2.add((Component)btnExtract, gbc_btnExtract);
        JLabel lblCopyright = new JLabel("Copyright \u00a9 2017 Wurst-Imperium. All rights reserved.");
        lblCopyright.setFont(new Font("Segoe UI", 0, 10));
        GridBagConstraints gbc_lblCopyright = new GridBagConstraints();
        gbc_lblCopyright.anchor = 15;
        gbc_lblCopyright.gridx = 0;
        gbc_lblCopyright.gridy = 5;
        panel.add((Component)lblCopyright, gbc_lblCopyright);
    }

    private Path findDotMinecraftFolder() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return Paths.get(System.getenv("APPDATA"), ".minecraft");
        }
        if (osName.contains("mac")) {
            return Paths.get(System.getProperty("user.home"), "Library", "Application Support", "minecraft");
        }
        return Paths.get(System.getProperty("user.home"), ".minecraft");
    }

    private void browse() {
        JFileChooser fileChooser = new JFileChooser(".");
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this.frmWurstClientInstaller) == 0) {
            this.txtPath.setText(fileChooser.getSelectedFile().toString());
        }
    }

    private void install() {
        Path dotMinecraft = this.getDotMinecraft();
        if (dotMinecraft == null) {
            return;
        }
        Path mcBase = this.getMcBase(dotMinecraft);
        if (mcBase == null) {
            return;
        }
        if (!this.extract(mcBase, dotMinecraft.resolve("versions"))) {
            return;
        }
        if (!this.addProfile(dotMinecraft)) {
            return;
        }
        JOptionPane.showMessageDialog(this.frmWurstClientInstaller, String.valueOf(this.config.getJarName()) + " has been successfully installed.", "Success", 1);
        this.frmWurstClientInstaller.dispose();
    }

    private void extract() {
        Path dotMinecraft = this.getDotMinecraft();
        if (dotMinecraft == null) {
            return;
        }
        Path mcBase = this.getMcBase(dotMinecraft);
        if (mcBase == null) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser(".");
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showSaveDialog(this.frmWurstClientInstaller) != 0) {
            return;
        }
        Path output = fileChooser.getSelectedFile().toPath();
        if (!this.extract(mcBase, output)) {
            return;
        }
        JOptionPane.showMessageDialog(this.frmWurstClientInstaller, String.valueOf(this.config.getJarName()) + " has been successfully extracted.", "Success", 1);
        this.frmWurstClientInstaller.dispose();
    }

    private void update(Path dotMinecraft, Path output) {
        Path mcBase = this.getMcBase(dotMinecraft);
        if (mcBase == null) {
            return;
        }
        try {
            this.applyPatch(mcBase, output);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frmWurstClientInstaller, e.toString(), "Error", 0);
        }
    }

    private Path getDotMinecraft() {
        try {
            Path dotMinecraft = Paths.get(this.txtPath.getText(), new String[0]);
            if (!Files.exists(dotMinecraft, new LinkOption[0]) || !Files.isDirectory(dotMinecraft, new LinkOption[0])) {
                throw new IOException();
            }
            return dotMinecraft;
        }
        catch (IOException | InvalidPathException e) {
            JOptionPane.showMessageDialog(this.frmWurstClientInstaller, "<html>Directory not found:<br>" + this.txtPath.getText(), "Error", 0);
            return null;
        }
    }

    private Path getMcBase(Path dotMinecraft) {
        Path mcBase = dotMinecraft.resolve("versions").resolve(this.config.getMcBase()).resolve(String.valueOf(this.config.getMcBase()) + ".jar");
        if (!Files.exists(mcBase, new LinkOption[0]) || !Files.isRegularFile(mcBase, new LinkOption[0])) {
            JOptionPane.showMessageDialog(this.frmWurstClientInstaller, "<html>Couldn't find Minecraft " + this.config.getMcBase() + " at:<br>" + mcBase + "<br><br>Please download Minecraft " + this.config.getMcBase() + " through the launcher and try again.", "Error", 0);
            return null;
        }
        return mcBase;
    }

    private boolean extract(Path mcBase, Path versions) {
        try {
            Path folder = versions.resolve(this.config.getJarName());
            Files.createDirectories(folder, new FileAttribute[0]);
            Path jar = folder.resolve(String.valueOf(this.config.getJarName()) + ".jar");
            this.applyPatch(mcBase, jar);
            Path json = folder.resolve(String.valueOf(this.config.getJarName()) + ".json");
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream in = ClientInstaller.class.getClassLoader().getResourceAsStream("assets/client.json");){
                Files.copy(in, json, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frmWurstClientInstaller, e.toString(), "Error", 0);
            return false;
        }
        return true;
    }

    private void applyPatch(Path mcBase, Path output) throws IOException {
        Path tmp = Files.createTempFile(mcBase.getParent(), null, null, new FileAttribute[0]);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = ClientInstaller.class.getClassLoader().getResourceAsStream("assets/client.patch");){
            Files.copy(in, tmp, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        byte[] mcBytes = Files.readAllBytes(mcBase);
        byte[] diffBytes = Files.readAllBytes(tmp);
        byte[] clientBytes = new byte[diffBytes.length];
        Files.deleteIfExists(tmp);
        int i = 0;
        while (i < diffBytes.length) {
            clientBytes[i] = (byte)(mcBytes[i % mcBytes.length] + diffBytes[i]);
            ++i;
        }
        Files.write(output, clientBytes, new OpenOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addProfile(Path dotMinecraft) {
        try {
            Map.Entry entry;
            JsonObject profile;
            JsonObject json;
            Path profilesFile = dotMinecraft.resolve("launcher_profiles.json");
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedReader reader = Files.newBufferedReader(profilesFile);){
                json = new JsonParser().parse((Reader)reader).getAsJsonObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
            JsonObject profiles = json.get("profiles").getAsJsonObject();
            Object object = profiles.entrySet().iterator();
            do {
                if (object.hasNext()) continue;
                JsonObject profile2 = new JsonObject();
                profile2.addProperty("name", this.config.getJarName());
                profile2.addProperty("type", "custom");
                profile2.addProperty("icon", "TNT");
                profile2.addProperty("lastVersionId", this.config.getJarName());
                profiles.add(this.config.getJarName(), (JsonElement)profile2);
                object = null;
                Object var7_11 = null;
                try (BufferedWriter writer = Files.newBufferedWriter(profilesFile, new OpenOption[0]);){
                    new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
                    return true;
                }
                catch (Throwable throwable3) {
                    if (object == null) {
                        object = throwable3;
                        throw object;
                    }
                    if (object == throwable3) throw object;
                    ((Throwable)object).addSuppressed(throwable3);
                    throw object;
                }
            } while (!(profile = ((JsonElement)(entry = (Map.Entry)object.next()).getValue()).getAsJsonObject()).has("lastVersionId") || !profile.get("lastVersionId").getAsString().equals(this.config.getJarName()));
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frmWurstClientInstaller, "<html>" + this.config.getJarName() + " has been successfully installed,<br>but an error occurred when we tried to create a profile for it.", "Warning", 2);
            return false;
        }
    }
}

